clear
set more off
capture log close
version 14


global d "D:\Home\aejack\Data\SpendingStudy\DataDocumentation\v2"
global j "D:\Home\aejack\Research\NewTechnologies\TillReceiptScanning\junk2"


* Participation in Scanning Study
************************************
* conditional on mobile device usage


* RQ4: Reasons for not participating
***************************************

* Open analysis file
use $j/cr-7, clear

svyset i_psu, strata(i_strata)

bysort pidp (starttime): keep if _n==1

* drop those found ineligible for the scanning study
drop if eligible==0
tab eligible

* number of people invited to spending study
count

* app download / scanning by IP9 non-respondents:
recode ip9outcome (1=1 "respondent") (0 = 2 "non-respondent"), gen(ip9)

tab ip9 download_dv, row mis
tab ip9 everapp_dv, row miss

* drop IP9 non-respondents
tab ip9
tab ip9, nolab
keep if ip9==1

tab smtabmiss, miss

sort pidp

* merge on debrief survey data
********************************

merge 1:1 pidp using $d/eop

tab smtabmiss _merge, miss
drop if _merge==2 // not in the analysis sample - may be IP9 non-respondents?
keep if smtabmiss==1 // mobile device users
drop if everapp_dv==1 // drop app participants
drop if download_dv==1 // drop if completed registration survey (because routed differently in debrief questionnaire)
keep if _merge==3 // responded to debrief survey


mvdecode mdiff1_tech_nr - mdiff1_link_nr  mdiff2_download_nr - mdiff2_time_nr, mv(-8)
mvdecode mdiff1_none mdiff2_none, mv(-8)

* include 'none of these' as a response option in the table 
* - so table reflects number of people who answered the questions, 
* not number who reported at least one difficulty

egen anyanswer = anycount(mdiff1_tech_nr - mdiff1_link_nr mdiff1_none mdiff2_download_nr - mdiff2_time_nr mdiff2_none), value(0 1)
lab var anyanswer "number of non-missing answers"

egen anydiff = anycount(mdiff1_tech_nr - mdiff1_link_nr  mdiff2_download_nr - mdiff2_time_nr), value(1)

tab anyanswer if pstat==3
tab anydiff if pstat==3
tab anydiff if anyanswer>0 & pstat==3

gen nodifficulty = anydiff==0
lab var nodifficulty "1: no difficulty reported"
tab anydiff nodifficulty, miss



* Table 3:
mrtab mdiff1_tech_nr - mdiff1_link_nr  mdiff2_download_nr - mdiff2_time_nr, sort descending
mrtab mdiff1_tech_nr - mdiff1_link_nr  mdiff2_download_nr - mdiff2_time_nr nodifficulty if pstat==3 & anyanswer>0, sort descending



 
egen nmentions = anycount(mdiff1_tech_nr - mdiff1_link_nr  mdiff2_download_nr - mdiff2_time_nr), values(1)
tab nmentions

d mdiff1_tech_nr mdiff1_intern mdiff1_storag mdiff1_OS_nr mdiff1_appsto mdiff1_link

gen techprob = (mdiff1_tech_nr==1 | mdiff1_intern==1 | mdiff1_storag==1 | mdiff1_OS_nr==1 |  ///
	mdiff1_appsto==1 | mdiff1_link==1)
lab def prob 1 "yes" 0 "no"
lab val techprob prob
lab var techprob "mentioned technical problem"

gen confprob = (mdiff2_downlo==1 | mdiff2_confid==1)
lab val confprob prob
lab var confprob "mentioned confidence problem"

gen privacyprob = (mdiff2_securi==1 | mdiff2_willin==1)
lab var privacyprob "mentioned privacy concern"
lab val privacyprob prob

* numbers in text:
mrtab techprob confprob privacyprob


exit




